PREPARATION OF PAPERS FOR JACoW CONFERENCES\*

A. N. Author^†^, H. Coauthor, Name of Institute or Affiliation, City,
Country\
P. Contributor^1^, Name of Institute or Affiliation, City, Country\
^1^also at Name of Secondary Institute or Affiliation City, Country

Abstract

Many conference series have adopted the same standards for electronic
publication and have joined the Joint Accelerator Conferences Website
(JACoW) collaboration for the publication of their proceedings. This
document describes the common requirements for the submission of papers
to these conferences. Please consult individual conference information
for page limits, method of electronic submission, etc. It is not
intended that this should be a tutorial in word processing; the aim is
to explain the particular requirements for electronic publication at
www.JACoW.org. The abstract itself is to act as a stand-alone entity
and, as such, should not include citations. Any acronyms should be
expanded on their first occurrence, both in the abstract and in the rest
of the paper.

## Submission of Papers {#submission-of-papers .JACoW_Section-Heading}

Each author should submit the PDF file and all source files (text and
figures) to enable the paper to be reconstructed if there are processing
difficulties.

## Manuscripts {#manuscripts .JACoW_Section-Heading}

Templates are provided for recommended software and authors are advised
to use them. Please consult the individual conference help pages if
questions arise.

### General Layout {#general-layout .JACoW_Subsection-Heading}

These instructions are a typical implementation of the requirements.
Manuscripts should have:

-   Either A4 (21.0 cm × 29.7 cm; 8.27 in × 11.69 in) or US letter size
    
> (21.6 cm × 27.9 cm; 8.5 in × 11.0 in) paper.
    
-   Single-spaced text in two columns of 82.5 mm (3.25 in) with 5.3 mm
    > (0.2 in) separation. More recent versions of Microsoft Word have a
    > default spacing of 1.5 lines; authors must change this to 1 line.

-   The text located within the margins specified in Table 1.

Table 1: Margin Specifications

--------------- -------------------------- -----------------------------
  **Margin**      **A4 Paper**               **US Letter Paper**

  Top             37 mm (1.46 in)            0.75 in (19 mm)

  Bottom          19 mm (0.75 in)            0.75 in (19 mm)

  Left            20 mm (0.79 in)            0.79 in (20 mm)

  Right           20 mm (0.79 in)            1.02 in (26 mm)
--------------- -------------------------- -----------------------------

###  Fonts {#fonts .JACoW_Subsection-Heading}

In order to produce good Adobe Acrobat PDF files, authors using the
JACoW LaTeX template are asked to use only the fonts defined in the
'jacow' class file in standard, bold (i.e., \\textbf) or italic
(i.e., \\textit) form and symbols from the standard set of fonts. In
Word use only Symbol and, depending on your platform, Times or Times New
Roman fonts in standard, bold or italic form.

The layout of the text on the page is illustrated in Fig. 1. Note that
the paper's title and the author list should be the width of the full
page. Tables and figures may span the whole 170 mm page width, if
desired (see Fig. 2), but if they span both columns, they should be
placed at either the top or bottom of a page to ensure proper flow of
the text (which should flow from top to bottom in each column).

![](media/image1.png){width="2.8055555555555554in"
height="3.7407338145231845in"}

Figure 1: Layout of papers.

### Title and Author List {#title-and-author-list .JACoW_Subsection-Heading}

The title should use 14 pt bold uppercase letters and be centred on the
page. Individual letters may be lowercased to avoid misinterpretation
(e.g., mW, GeV, SPring-8, SwissFEL). To include a funding support
statement, put an asterisk after the title and the support text at the
bottom of the first column on page 1 ‑ in Word, use a text box; in
LaTeX, use \\thanks. See also the subsection on footnotes.

![](media/image2.jpeg){width="6.69375in" height="3.78125in"}

Figure 2: Example of a full-width figure showing the JACoW Team at their
annual meeting in December 2018. This figure has a multi-line caption
that has to be justified rather than centred.

The names of authors, their organizations/affiliations and postal
addresses should be grouped by affiliation and listed in 12 pt upper-
and lowercase letters. The name of the submitting or primary author
should be first, followed by the coauthors, alphabetically by
affiliation. Where authors have multiple affiliations, the secondary
affiliation may be indicated with a superscript, as shown in the author
listing of this paper. See **ANNEX A** for further examples.

### Section Headings {#section-headings .JACoW_Subsection-Heading}

Section headings should not be numbered. They should use 12 pt bold
uppercase letters and be centred in the column. All section headings
should appear directly above the text - there should never be a column
break between a heading and the following paragraph.

### Subsection Headings {#subsection-headings .JACoW_Subsection-Heading}

Subsection headings should not be numbered. They should use 12 pt italic
letters and be left aligned in the column. Subsection headings use Title
Case (or Initial Caps) and should appear directly above the text\--there
should never be a column break between a subheading and the following
paragraph.

Third-level Headings These should use 10 pt bold letters and be run into
the paragraph text. In LaTeX they are created with LaTeX's
\\subsubsection command. In the Word templates authors must bold the
heading text themselves. This heading should be used sparingly. See
Table 2 for its style details.

### Paragraph Text {#paragraph-text .JACoW_Subsection-Heading}

Paragraphs should use 10 pt font and be justified (touch each side) in
the column. The beginning of each paragraph should be indented
approximately 0.33 cm (0.13 in). The last line of a paragraph should not
be printed by itself at the beginning of a column nor should the first
line of a paragraph be printed by itself at the end of a column.

### Figures, Tables, and Equations {#figures-tables-and-equations .JACoW_Subsection-Heading}

Place figures and tables as close to their place of mention as possible.
Lettering in figures and tables should be large enough to reproduce
clearly. Use of non-approved fonts in figures can lead to problems when
the files are processed. LaTeX users should be sure to use non-bitmapped
versions of Computer Modern fonts in equations (Type 1 PostScript or
OpenType fonts are required. Their use is described in the help pages of
the JACoW website \[1\]).

Each figure and table must be numbered in ascending order (1, 2, 3,
etc.) throughout the paper. After inserting a figure in a Word document,
click on the figure, right click on "Wrap Text", and select the "In Line
with Text" option. Figure captions are placed below figures, and table
captions are placed above tables.

Figure captions are formatted as shown in Figs. 1 and 2, while table
captions take the form of a heading, with initial letters of principle
words, capitalized, and without a period at the end (see Tables 1 and
2). Any reference to the contents of the table should be made from the
text of the paper rather than from within the table caption itself.

Single-line captions are centred in the column, while captions that span
more than one line should be justified. Both figure and table captions
may be easily inserted from the "References" tab by clicking on the
"Insert Caption" button on the "Captions" menu. (An alternative is to
simply right click on the figure or table anchor and select "Insert
Caption".) Select "figure" or "table" in the caption as the label as
appropriate. The figure label should be configured to appear below the
figure, while the table label is set to appear above the table. Enter
the figure/table caption in the box provided and click "OK". Finally,
where necessary, modify the font style (10 pt, normal) and spacing to
match that listed in Table 2, not forgetting the colon after the
figure/table numeric (e.g., Figure 1:). The LaTeX template, in
comparison, uses the 'booktabs' package to format tables. A figure in a
Word document may be made to span two columns by the following
procedure:

1.  Insert a continuous section break.

2.  Insert two empty lines (makes later editing easier).

3.  Insert another continuous section break.

4.  Click between the two section breaks and then click on the following
    menus and tabs:\
    Page Layout → Columns → One.

5.  Paste the figure between the section breaks and adjust the size as
    appropriate.

6.  Remove blank lines from in and around the figure.

When referring to a figure from within the text, the convention is to
use the abbreviated form \[e.g., Fig. 1\] *unless* the reference is at
the start of the sentence, in which case "Figure" is written in full.
Reference to a table, however, is never abbreviated \[e.g., Table 1\].

If a displayed equation needs a number (i.e., it will be referenced),
place it in parentheses, and flush with the right margin of the column.
The equation itself should be indented and centred, as far as is
possible:

![](media/image3.wmf). (1)

When referencing a numbered equation, use the word "Equation" at the
start of a sentence, and the abbreviated form, "Eq.", if in the text.
The equation number is placed in parentheses \[e.g., Eq. (1)\].

### Units {#units .JACoW_Subsection-Heading}

Units should be written using the standard, roman font, not the italic
font, as shown in Eq. (1). An unbreakable space should precede a unit.
Some examples are: 3 keV, 100 kW, 7 μm. When a unit appears in a
hyphenated, compound adjective that precedes a noun, it takes on the
singular form, e.g., the 3.8-metre long undulator.

### References {#references .JACoW_Subsection-Heading}

All bibliographical and web references should be numbered and listed at
the end of the paper in a section called **REFERENCES**. When citing a
reference in the text, place the corresponding reference number in
square brackets \[2\]. The reference citations in the text should be
numbered in ascending order. Multiple citations should appear in the
same bracket \[3, 4\] and with ranges where appropriate \[1-4, 10\].

A URL may be included as part of a reference, but its hyperlink should
NOT be added. The usual practice is to use a monospaced font for the URL
so as to help distinguish it from normal text. The Word template uses
the Liberation Mono TrueType font (size 8 pt), or Lucida Sans Typewriter
font (size 7.5 pt) in earlier Word versions where the Liberation Mono
font may not be available. In LaTeX, the 'url' package is used.

For authors to properly cite the resources used when researching their
papers is an obligation. In the interest of promoting uniformity and
complete citations, the IEEE Editorial Style for Transactions and
Journals, which itself adheres to the Chicago Manual of Style, has been
adopted \[2\]. When citing a periodical, the official abbreviation of
the journal should be used \[3\]. Please consult the appended material,
**ANNEX B**, for details. The onus is on authors to pay attention to the
details of the said style to ensure complete, accurate and properly
formatted references.

### Footnotes {#footnotes .JACoW_Subsection-Heading}

Footnotes on the title and author lines may be used for acknowledgements
and e-mail addresses. A non-numeric sequence of characters (\*, ^†^,
^‡^, ^§^, ^¶^) should be used to indicate the footnote. Word users---DO
NOT use Word's footnote feature (**Insert**, **Footnote**) to insert
footnotes, as this will create formatting problems. Instead, insert the
title or author footnotes manually in a text box at the bottom of the
first column with a line at the top of the text box to separate the
footnotes from the rest of the paper's text. The easiest way to do this
is to copy the text box from the JACoW template and paste it into your
own document. These "pseudo footnotes" in the text box should only
appear at the bottom of the first column on the first page.

Any other footnote in the body of the paper must be created using the
text box procedure described in the paragraph above using the normal
numeric sequencing (i.e., 1, 2, 3) and appearing at the bottom of the
same column in which it is used. All footnotes are of 8pt font size.

### Acronyms

Acronyms should be defined the first time they appear, both in the
abstract and in the rest of the paper.

## Styles {#styles .JACoW_Section-Heading}

Table 2 summarizes the fonts and spacing used in the styles of a JACoW
template. In LaTeX, these are implemented in the 'jacow' class file.

## Page Numbers {#page-numbers .JACoW_Section-Heading}

**DO NOT include any page numbers**. They will be added when the final
proceedings are produced.

Table 2: Summary of Styles

------------------- ------------------------- ------------ ------------
  **Style**           **Font**                  **Space**\   **Space**\
                                                **Before**   **After**

  **PAPER TITLE**     14 pt\                    0 pt         3 pt
                      **UPPERCASE EXCEPT FOR                 
                      REQUIRED lowercase                     
                      letters\                               
                      Bold**                                 

  Author List         12 pt\                    9 pt         12 pt
                      UPPER- and lowercase                   

  *Abstract Title*    12 pt\                    0 pt         3 pt
                      *Initial Caps\                         
                      Italic*                                

  **SECTION\          12 pt\                    9 pt         3 pt
  HEADING**^1^        **UPPERCASE**\                         
                      **Bold**                               

  *Subsection\        12 pt\                    6 pt         3 pt
  Heading*^1^         *Initial Caps\                         
                      Italic*                                

  **Third-level       10 pt\                    6 pt         0 pt
  Heading**^1^** **   **Initial Caps\                        
                      Bold **                                

  Figure\             10 pt                     3 pt         ≥ 3 pt
  Caption^1^                                                 

  Table\              10 pt                     ≥ 3 pt       3 pt
  Caption^1^                                                 

  Equation^1^         10 pt base font           ≥ 6 pt       ≥ 6 pt

  References when ≤ 9 9 pt, justified with      0 pt         3 pt
                      0.52 cm (0.2 in) hanging               
                      indent                                 

  Refs^2^. 1-9 when ≥ 9 pt, justified with      0 pt         3 pt
  10                  0.16 cm (0.06 in) left                 
                      indent and 0.52 cm                     
                      (0.2 in) hanging indent                

  Refs^2^. 10 onwards 9 pt, justified with      0 pt         3 pt
                      0.68 cm (0.26 in) hanging              
                      indent                                 
------------------- ------------------------- ------------ ------------

##  Templates {#templates .JACoW_Section-Heading}

Template documents for the recommended word processing software are
available from the JACoW website \[1\] and exist for LaTeX, Microsoft
Word (Mac and PC) and LibreOffice/Apache OpenOffice for US letter and A4
paper sizes.

Use the correct template for your paper size and version of Word. Do not
transport Microsoft Word documents across platforms (e.g., Mac ↔ PC). To
ensure that fonts are embedded in Word 2010 documents (PC), the "Embed
fonts in file" option must be selected from within the Word
Options → Save window. Fonts are embedded by default when printing to
PDF on MAC OSX.

## Checklist for electronic Publication {#checklist-for-electronic-publication .JACoW_Section-Heading}

Authors are requested to go over the following checklist for electronic
publication:

-   Use only Times or Times New Roman (standard, bold or italic) and
    > Symbol fonts for text, 10 pt except references, which should be
    > 9 pt.

-   Figures should use Times or Times New Roman (standard, bold or
    > italic) and Symbol fonts when possible ‑ 6 pt minimum, with fonts
    > embedded.

-   Check that citations to references appear in sequential order and
    
> that all references are cited.
    
-   Check that the PDF file prints correctly.

-   Check that there are no page numbers.

-   Check that the margins on the printed version are within ±1 mm of
    
> the specifications.
    
-   LaTeX users can check their margins by invoking the boxit option.

Please also check the list of common oversights which can be found in
**ANNEX C**.

## CONCLUSION {#conclusion .JACoW_Section-Heading}

Any conclusions should be in a separate section directly preceding the
**ACKNOWLEDGEMENTS**, **APPENDIX**, or **REFERENCES** section, in that
order.

## acknowledgEmentS {#acknowledgements .JACoW_Section-Heading}

Any acknowledgements should be in a separate section directly preceding
the **REFERENCES** or **APPENDIX** section.

## APPENDIX {#appendix .JACoW_Section-Heading}

Any appendix should be in a separate section directly preceding the
**REFERENCES** section. If there is no **REFERENCES** section, this
should be the last section of the paper.

## References {#references-1 .JACoW_Section-Heading}

\[1\] JACoW, http://www.jacow.org

\[2\] *IEEE Editorial Style Manual*, IEEE Periodicals, Piscataway, NJ,
USA, Oct. 2014, pp. 34-52.

\[3\]
https://woodward.library.ubc.ca/research-help/journal-abbreviations/

## ANNEX A: FORMATTING OF AUTHORs AND AFFILIATIONs {#annex-a-formatting-of-authors-and-affiliations .JACoW_Section-Heading}

The names of authors, their organizations/affiliations and postal
addresses should be grouped by affiliation and listed in 12 pt upper-
and lowercase letters. The name of the submitting or primary author
should be first, followed by the coauthors, alphabetically by
affiliation. If the author list for a given affiliation spans multiple
lines, please be sure to break the line in a manner that does not split
the author's initials from the author's last name. This is easily done
by placing unbreakable spaces between the initials and last name. The
affiliation name and address are also best kept together on the same
(but not necessarily separate) line, wherever possible. (See, for
example, the entry for GSI in the following.) In cases where authors
have multiple affiliations, the secondary affiliation is inserted below
the author/primary affiliation listing and is indicated with a
superscript, as shown in the following.

Footnotes on the title and author lines may be used for acknowledgements
and e-mail addresses, using a non-numeric sequence of characters (\*,
^†^, ^‡^, ^§^, ^¶^). In Word, footnotes are best inserted manually in a
text box at the bottom of the first column with a line at the top of the
text box to separate the footnotes from the rest of the paper's text.

For examples of the preferred formatting of authors and affiliations,
please consult the following list of JACoW collaboration members.

For manuscripts submitted by large collaborations with potentially many
tens of authors and where, additionally, there may be page number
limitations, a format consisting of the principle author's name and
institute, followed by "on behalf of the ... collaboration", is
preferred.

THE JACoW COLLABORATION\*

C. Petit-Jean-Genaz, J. Poole^1^, T. Baron, R. Billen, P. Ferreira,
N. Juszka, M. Kołodziejski,\
A. Mönnich, P. Poulopoulou, M. Vidal, CERN, 1211 Geneva 23, Switzerland\
C. E. Eyberger, K. Jaje, Y. Jaski, Argonne National Laboratory, Lemont,
IL 60439, USA\
D. Button, M. Hewes, ANSTO, Lucas Heights NSW 2234, Australia\
R. Dowd, K. Riches, E. Tan, N. White,\
ANSTO, Australian Synchrotron, Clayton VIC 3168, Australia\
R. Picoreti, S. Marques, Brazilian Synchrontron Light Laboratory,
13083-970 Campinas, Brazil\
P. Dyer, C. Hoffman, Brookhaven National Laboratory, Upton, NY 11973,
USA\
M. V. Kuzin, Budker Institute of Nuclear Physics, 630090 Novosibirsk,
Russia\
L. Serani, Centre d'Etudes Nucléaires de Bordeaux Gradignan,\
Université de Bordeaux/IN2P3/CNRS, 33175 Gradignan, France\
M. Marx, Deutsches Elektronen-Synchrotron, 22607 Hamburg, Germany\
I. Andrian^†^, S. Deiuri, Elettra Sincrotrone Trieste, 34149 Basovizza,
Italy\
J. Olander, G. Trahern, European Spallation Source, 221 00 Lund, Sweden\
F. Chautard, Grand Accélérateur National d\'Ions Lourds, 14076 Caen,
France\
M. Arena, Fermilab, Batavia IL 60510, USA\
R. Müller, V. R. W. Schaa^‡^\
GSI Helmholtzzentrum für Schwerionenforschung, 64291 Darmstadt, Germany\
M. McAteer, Helmholtz-Zentrum Berlin, 14109 Berlin, Germany\
P. Neumann, Helmholtz-Zentrum Dresden-Rossendorf, 01328 Dresden,
Germany\
Y.-Y Li, Hong Kong University of Science and Technology, Hong Kong,
P. R. China\
P. Pisciotta, INFN-LNS, 95123 Catania, Italy\
N. Zhao, Institute of High Energy Physics, Beijing 100049, P. R. China\
L. Li, Institute of Modern Physics, Lanzhou 730000, P. R. China\
J. G. de Villiers, J. Mira, iThemba Labs, P.O. Box 722, Somerset West
7130, South Africa\
Y. H. Chin, K. Furukawa, T. Kosuge, A. Shirakawa, KEK, Tsukuba, Ibaraki
305-0801, Japan\
P. Snopok, Illinois Institute of Technology, Chicago, IL 60616, USA\
R. Apsimon, Cockcroft Institute, Lancaster University, Lancaster LA1
4YW, UK\
K. A. Bishofberger, Los Alamos National Laboratory, Los Alamos, NM
87545, USA\
V. G. Mitts, CAMD, Louisiana State University, Baton Rouge, LA 70806,
USA\
K. Makino, A. McCausey,Michigan State University, East Lansing, MI
48824, USA\
T. Tanaka, LEBRA, Nihon University, Funabashi 274-8501, Japan\
C. Horak, Oak Ridge National Laboratory, Oak Ridge, TN 37831, USA\
Y.-S. Cheng\
National Synchrotron Radiation Research Center, Hsinchu 30076, Taiwan
(Rep. of China)\
J. Chrin^§^, Paul Scherrer Institut, 5232 Villigen PSI, Switzerland\
D.-E. Kim, G.-H. Kim, K.-S. Kim, N.-Y. Kim, E.-H. Lee\
Pohang Accelerator Laboratory, Gyeongbuk, Korea\
A. Uchiyama, K. Yamada, RIKEN, Wako, Saitama 351-0198, Japan\
H. Chen, X. Han, W. Qi, Shanghai Institute of Applied Physics, Shanghai
201800, P. R. China\
M. Montes-Loera, SLAC National Accelerator Laboratory, Menlo Park, CA
94025, USA\
S. Waller, STFC Daresbury Laboratory, Warrington WA4 4AD, UK\
K. Tavakoli, Synchrotron Soleil, Saint-Aubin, 91192 Gif-sur-Yvette,
France\
E. Akers, A. Cuffe, T. Satogata^¶^\
Thomas Jefferson National Accelerator Facility, Newport News, VA 23606,
USA\
J. Thomson, TRIUMF, Vancouver, BC V6T 2A3, Canada\
^1^also at JP Scientific (Nantwich) Ltd, UK

## ANNEX B: IEEE Reference STYLE GUIDE AS APPLIED to JACoW PAPERS, PERIODICALS AND OTHER WORKS {#annex-b-ieee-reference-style-guide-as-applied-to-jacow-papers-periodicals-and-other-works .JACoW_Section-Heading}

### Referencing JACoW Proceedings {#referencing-jacow-proceedings .JACoW_Subsection-Heading}

The format for published JACoW proceedings papers is detailed in the
following and can also be readily deduced from \[1-3\]. At the very
minimum, sufficient information should be given to enable readers to
clearly identify the paper and to facilitate its import into digital
databases.

**Author Listing** Careful attention should be given to the placing of
commas and the use of 'and' in the author list. In particular, for the
case of three or more authors (as in \[3\]), a comma also follows the
penultimate author. The preference for *et al*. takes precedence when
the number of authors becomes large (e.g., \> 6).

**Paper Title **As is modern practice in references, the title of the
paper is written in sentence case, i.e., only the initial letter of the
first word in the title is capitalized. Proper nouns, however, also have
a capital. Capital letters appearing in acronyms likewise remain
unaltered.

**Conference Proceedings **The title of the proceedings is written in
title case in italics using standard abbreviations, such as *Int.* and
*Conf.* The preposition, "in", in normal font, precedes the proceedings
title. The location, i.e., city, state (if USA), and country of the
conference venue, the month (three-letter abbreviation) and the year the
conference took place, is then listed. Finally, details pertaining to
the paper itself, such as the conference paper ID, mandatory page
numbers, and the digital object identifier (DOI), if existing, are
listed in the given order. A monospaced font for the DOI is used so as
to help distinguish it from normal text. The Word template uses the
Liberation Mono TrueType font (size 8 pt), or Lucida Sans Typewriter
font (size 7.5 pt) in earlier Word versions where the Liberation Mono
font may not be available. In LaTeX, the 'url' package is used. The
conference paper ID is optional and may be included in the absence of a
DOI to facilitate a search through internet search engines. DOIs have
been assigned to all JACoW publications appearing in recent proceedings
and will likewise be assigned to articles from conferences further past,
in due course. The use of DOIs is strongly emphasized.

The complete or abbreviated form for citations, as shown in the
following section, is advocated. The former is more informative to
readers outside the immediate conference sphere, and will further serve
to avoid potential ambiguities in cases where an acronym is not unique.
Both forms, however, when adhered to, ensure a proper import into
digital libraries and information sources such as INSPIRE, Scopus, and
Google Scholar. Authors are also reminded to make a distinction between
papers published in JACoW proceedings (which have page numbers and, in
the case of recent publications, DOIs) and those papers that may have
been presented at past JACoW conferences but were not published \[4\].
References to contributions presented at the same conference should be
written as shown in \[5\]; the wording "this conference" may be
optionally appended.

### Referencing Periodicals and Other Sources {#referencing-periodicals-and-other-sources .JACoW_Subsection-Heading}

The IEEE style is also shown for periodicals \[6-11\], online
sources \[12\], books \[13, 14\], internal reports \[15\],
theses \[16\], manuals or handbooks \[17\], patents \[18\] and
unpublished material \[19, 20\]. When citing a periodical, only the
official abbreviation of the journal should be used \[21\]. Examples of
correctly formatted references can also be found at the JACoW website,
under 'Formatting Citations' which is reached through the 'for Authors'
link.

### Alignment of References {#alignment-of-references .JACoW_Subsection-Heading}

Entries to the References section follow a hanging indent structure. In
this way, reference numbers in the first line of each reference entry
are right aligned, while subsequent lines within a given reference are
indented by a specified amount. The indentation values for Word are
summarized in Table 1 of this Annex and depend on whether the number of
references exceeds single digit values.

In the LaTeX template, \\bibliography{9} is used for when the total
number of references is less than ten. This should be changed to
\\bibliography{99} if the number of references is ten or more.

Table 1: Formatting of References

-------------------------------------------------------------------------
  Font            Left\           Hanging Indent  Space Before Space After
                  Indent                                       
--------------- --------------- --------------- ------------ ------------
  No. References                                               
  ≤ 9                                                          

  9 pt,\          0.00 cm\        0.52 cm\        0 pt         3 pt
  justified       0.00 in         0.20 in                      

  No. References                                               
  ≥ 10                                                         

  Refs. 1 to 9                                                 

  9 pt,\          0.16 cm\        0.52 cm\        0 pt         3 pt
  justified       0.06 in         0.20 in                      

  Refs. 10                                                     
  onwards                                                      

  9 pt,\          0.00 cm\        0.68 cm\        0 pt         3 pt
  justified       0.00 in         0.26 in                      
  -------------------------------------------------------------------------

## PAPER PUBLISHED IN A CONFERENCE PROCEEDINGS {#paper-published-in-a-conference-proceedings .JACoW_Section-Heading}

*Complete Form*

\[1\] A. Alpha and B. T. Beta, "Novel techniques for future TeV electron
accelerators", in *Proc. 9th Int. Particle Accelerator Conf. (IPAC'18)*,
Vancouver, BC, Canada, Apr.-May 2018, pp. 57-59.
doi:10.18429/JACoW-IPAC2018-PAPERID

\[Conference Proceedings, two authors; DOI encouraged\]

\[2\] A. Alpha *et al.*, "A novel injector", in *Proc. 29th Linear
Accelerator Conf. (LINAC'18)*, Shanghai, China, Sep. 2018, pp. 27-30.
doi:10.18429/JACoW-LINAC2018-PAPERID

\[Conference Proceedings, for six or more authors use *et al.;* DOI
encouraged\]

\[3\] A. Alpha, B. T. Beta, C. Gamma, and D. Delta, "An overview of
control systems", in *Proc. 13th Int. Conf. on Accelerator and Large
Experimental Physics Control Systems (ICALEPCS'11)*, Grenoble, France,
Oct. 2011, paper TUP014, pp. 89-91.

\[Conference Proceedings, four authors; optional paper ID in the absence
of a DOI\]

*Abbreviated Form*

\[1\] A. Alpha and B. T. Beta, "Novel techniques for future TeV electron
accelerators", in *Proc. IPAC'18*, Vancouver, BC,
Canada, Apr.-May 2018, pp. 57-59.\
doi:10.18429/JACoW-IPAC2018-PAPERID

\[Conference Proceedings, two authors; DOI encouraged\]

\[2\] A. Alpha *et al.*, "A novel injector", in *Proc. LINAC'18*,
Shanghai, China, Sep. 2018, pp. 27-30.
doi:10.18429/JACoW-LINAC2018-PAPERID

\[Conference Proceedings, for six or more authors use *et al.;* DOI
encouraged\]

\[3\] A. Alpha, B. T. Beta, C. Gamma, and D. Delta, "An overview of
control systems", in *Proc. ICALEPCS'11*, Grenoble, France, Oct. 2011,
paper TUP014, pp. 89-91.

\[Conference Proceedings, four authors; optional paper ID in the absence
of a DOI\]

## UNPUBLISHED PAPER PRESENTED AT A PREVIOUS CONFERENCE {#unpublished-paper-presented-at-a-previous-conference .JACoW_Section-Heading}

*Complete Form*

\[4\] A. Alpha and B. T. Beta, "An interesting talk but paper not
submitted", presented at the 5th Int. Particle Accelerator Conf.
(IPAC'14), Dresden, Germany, Jun. 2014, paper MOP057, unpublished.

\[Unpublished paper; conference name in normal font; paper ID may only
be given if material supplementing the proceedings exists on the JACoW
website, e.g., PDF of talk\]

### Abbreviated Form {#abbreviated-form .JACoW_Subsection-Heading}

\[4\] A. Alpha and B. T. Beta, "An interesting talk but paper not
submitted", presented at IPAC'14, Dresden, Germany, Jun. 2014, paper
MOP057, unpublished.

\[Unpublished paper; conference name in normal font; paper ID may only
be given if material supplementing the proceedings exists on the JACoW
website, e.g., PDF of talk\]

## PAPER PRESENTED AT THE CURRENT CONFERENCE {#paper-presented-at-the-current-conference .JACoW_Section-Heading}

*Complete Form*

\[5\] A. Alpha and B. T. Beta, "An interesting talk at this conference",
presented at the 10th Int. Particle Accelerator Conf. (IPAC'19),
Melbourne, Australia, May 2019, paper MOAB01, this conference.

\[Current conference; conference name in normal font; the wording "this
conference" is optional\]

*Abbreviated Form*

\[5\] A. Alpha and B. T. Beta, "An interesting talk at this conference",
presented at IPAC'19, Melbourne, Australia, May 2019, paper MOAB01, this
conference.

\[Current conference; conference name in normal font; the wording "this
conference" is optional\]

## PAPER PUBLISHED IN, OR SUBMITTED TO, A PERIODICAL {#paper-published-in-or-submitted-to-a-periodical .JACoW_Section-Heading}

\[6\] P. Mercury *et al.*, "Title of paper published in journal", *Phy.
Rev. Lett.*, vol. 114, no. 5, p. 050511, Feb. 2014.
doi:10.1103/PhysRevLett.114.050511

\[Periodical, *Phys. Rev. Lett*.; issue no. and month may be omitted\]

\[7\] P. Venus *et al.*, "New techniques in laser wakefield
accelerators", *Phys. Rev. Accel. Beams*, vol. 22, p. 014601,
Jan. 2019.\
doi:10.1103/PhysRevAccelBeams.22.014601

\[Periodical, *Phys. Rev. ST Accel. Beams*; month may be omitted\]

\[8\] T. Earth *et al.*, "Low dose irradiation impact on modern silicon
detectors", *Nucl. Instrum. Methods*, vol. 692, pp. 256-280, 2014.
doi:10.1016/j.nima.2014.11.022

\[Periodical, *Nucl. Instrum. Methods*\]

\[9\] T. Earth, L. Moon, and A. Belt, "Temporal correlations of x-ray
free electron lasers", *Optics Express*, vol. 20, pp. 11396-11404, 2012.
doi:10.1364/OE.20.11396

\[Periodical, *Optics Express*\]

\[10\] J. B. Good, "A paper accepted for publication", *Phys. Rev.
Lett.*, to be published.

\[Periodical, paper accepted for publication by *Phys. Rev. Lett.*\]

\[11\] G. D. Read, "Title of paper submitted for publication", submitted
for publication.

\[Paper submitted for publication; the name of the periodical does not
appear\]

## ONLINE SOURCE {#online-source .JACoW_Section-Heading}

\[12\] JACoW, http://www.jacow.org

\[Online source; no hyperlink, no period at end of URL unless there is a
trailing "/" as shown below. A monospaced font, such as Liberation Mono
(size 8 pt), is used in Word, while the 'url' package is used in LaTeX\]

\[12\] JACoW, http://www.jacow.org/.

\[Online source; no hyperlink, period after trailing "/" in URL if
optionally preferred. A monospaced font, such as Liberation Mono (size
8 pt), is used in Word, while the 'url' package is used in LaTeX\]

## CITATIONS TO BOOKS {#citations-to-books .JACoW_Section-Heading}

\[13\] T. Earth and L. Moon, "Title of chapter in the book", in *Title
of Book*, R Mars, Ed. New York, NY, USA: Wiley, 1994, pp. 42-48.

\[Chapter in book\]

\[14\] A. Belt, *Title of Book*. Cambridge, MA, USA: MIT Press, 1986.

\[Book\]

##  REPORTS AND THESES {#reports-and-theses .JACoW_Section-Heading}

\[15\] G. Jupiter *et al.,* "Title of report", CERN, Geneva,
Switzerland, Rep. CERN-2012-333, Oct. 2012.

\[Report\]

\[16\] A. Student, "Title of thesis", Ph.D. thesis, Phys. Dept.,
Karlsruher Institut für Technologie, Karlsruhe, Germany, 2014.

\[Thesis\]

## MANUAL {#manual .JACoW_Section-Heading}

\[17\] *IEEE Editorial Style Manual*, IEEE Periodicals, Piscataway, NJ,
USA, Oct. 2014, pp. 34-52, http://www.
ieee.org/documents/style_manual.pdf

\[Handbook/Manual, no hyperlink, no period after URL\]

##  PATENTS {#patents .JACoW_Section-Heading}

\[18\] A. N. Inventor, "Title of patent", Patent Authority and No., Jan.
20, 2016.

## UNPUBLISHED WORK AND PRIVATE COMMUNICATION {#unpublished-work-and-private-communication .JACoW_Section-Heading}

\[19\] P. Neptune, "Title of paper", unpublished.

\[Unpublished\]

\[20\] P. Uranus, private communication, Jun. 2015.

\[Private communication\]

## JOURNAL ABBREVIATIONS {#journal-abbreviations .JACoW_Section-Heading}

\[21\]
https://woodward.library.ubc.ca/research-help/journal-abbreviations/

## ANNEX C: THE DILIGENT AUTHOR'S CHECKLIST {#annex-c-the-diligent-authors-checklist .JACoW_Section-Heading}

### Common Oversights {#common-oversights .JACoW_Subsection-Heading}

In order to lessen the load on a small team of editors and to help
expedite publication of the Proceedings, authors are kindly asked to
give themselves an extra few minutes to go over the following points,
which highlight the most common errors, before uploading their paper. By
providing a properly formatted JACoW paper, the Proceedings Office is
able to benefit from an autodistill process which automatically converts
the author\'s PDF file into a version that adheres to the
JACoW-compliant PDF standard. The process further ensures that all fonts
required to view the entire document are embedded, rendering a final PDF
that qualifies technically for publication.

### Author and Affiliation Listing {#author-and-affiliation-listing .JACoW_Subsection-Heading}

The names of authors and their affiliations should be in 12 pt uppercase
and lowercase letters, with standard, roman fonts (i.e., not italics).
When there is more than one author, the submitting author should be
first, followed by the coauthor. Coauthors should be grouped by
affiliation and then be listed alphabetically. Please refer to **ANNEX
A** for further details and examples, particularly for the case where
authors have multiple institutes.

### SPMS Database and Final Manuscript Validation {#spms-database-and-final-manuscript-validation .JACoW_Subsection-Heading}

Primary authors are reminded that it is their responsibility to verify
the accuracy of the title, abstract, and coauthor/institute listing, and
that these are identical in both the final manuscript and SPMS database.
This is required to ensure the proper indexing of author/coauthor(s)
appear in the published proceedings.

### Subsection Headings {#subsection-headings-1 .JACoW_Subsection-Heading}

Subsection Headings are in 12 pt *italic* lowercase and uppercase.  The
initial letter of every principle word is capitalized, and the heading
is left aligned in the column.

### Figure Captions {#figure-captions .JACoW_Subsection-Heading}

Figure captions should be placed below the figure and centred if on one
line, but justified if spanning two or more lines:

Figure 1: A one line figure caption is centred.

Figure 2: A lengthy figure caption that spans two lines is justified.

Note the colon ":" after the figure number and the period "." at the end
of the caption.

When referring to a figure from within the text, the convention is to
use the abbreviated form, i.e., Fig. 1, *unless* the reference to the
figure is at the start of the sentence:

Figure 1 shows a schematic view of\...

\... as shown in Fig. 1.

### Table Headings {#table-headings .JACoW_Subsection-Heading}

Table captions should be placed above the table and centred if on one
line, but justified if spanning two or more lines:

Table 1: Table Heading

Table 2: A Particularly Long Table Heading Spanning Two Lines

Note the colon ":" after the table number, that the initial letters of
the principle words in the table heading are capitalized, and the
absence of a period at the end of the caption.

When referring to a table from within the text, the convention is *not*
to abbreviate, i.e., Table 1.

### Equations {#equations .JACoW_Subsection-Heading}

If a displayed equation requires a number, it should be placed flush
with the right margin of the column. Please leave sufficient space
immediately before and after the equation, i.e., in Microsoft Word, with
6 to 12 pt before and after.

### Units {#units-1 .JACoW_Subsection-Heading}

An unbreakable space should always precede a unit. Examples are: 3 keV,
4 GeV, 100 kW, 7 μm.

### References {#references-2 .JACoW_Subsection-Heading}

References are written in 9 pt size and should be neatly presented in a
consistent format with reference numbers aligned. Please refer to
**ANNEX B** for the preferred format and proper alignment.

Please also ensure that references in the text are cited in sequential
order.
